// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "fragmentVersionCentroid.h"

#if __VERSION__ >= 300
	#ifndef BYPASS_PIXEL_SHADER
		#if defined(TEXEL_AA) && defined(TEXEL_AA_FEATURE)
			_centroid in highp vec2 uv0;
			_centroid in highp vec2 uv1;
		#else
			_centroid in vec2 uv0;
			_centroid in vec2 uv1;
		#endif
	#endif
#else
	#ifndef BYPASS_PIXEL_SHADER
		varying highp vec2 uv0;
		varying highp vec2 uv1;
	#endif
#endif

varying vec4 color;
varying highp vec3 p;
varying highp vec3 wpos;
varying highp vec3 spos;
varying highp float skp;

#ifdef FOG
varying vec4 fogColor;
#endif

#include "uniformShaderConstants.h"
#include "util.h"

LAYOUT_BINDING(0) uniform sampler2D TEXTURE_0;
LAYOUT_BINDING(1) uniform sampler2D TEXTURE_1;
LAYOUT_BINDING(2) uniform sampler2D TEXTURE_2;

#include "flora.h"

#define C color
#define nc normalize(C.rgb)
#define db normalize(cross(dFdx(p), dFdy(p)))
#define plants (db.y<0.9 && db.y>-0.9 && db.x <0.99 && db.x > -.99 && db.z >-0.9 && db.z <0.9)
#define waters (C.a>0.&&nc.b>nc.r&&nc.b<nc.r+nc.g*2.5&&nc.r<0.3)

#define smixu(x,y,z) mix(y,mix(x, z, ssd), dd)
#define skhu smixu(dhr, nhr, shr)
#define skcu smixu(dsk, nsk, ssk)

#ifdef WATERSURFACE
highp float wavef(float amp,float widthx, float zp, float xp, float speedz){

  	    float wave = sin(p.z * 2. * PI/16. + zp + TIME * speedz ) * amp + amp;
  	    float cen = mod(-p.x + -p.y*1.5 + xp + TIME * -2., widthx);
  	    bool wavep = (wave < cen && wave > cen - 1.);
  	    if(wavep)return mix(1.065,1.,1. + wave - cen);
  	    else return 1.;
}

highp float waveb(){
  return 
    wavef(0.5, 4.0, 0.0, 0.0, 1.0)
  * wavef(0.2, 2.0, 8.0, 0.5, 0.3 * PI);
}
#endif

#if SIDEDIRLIGHT

highp float sidel(){
  #ifdef dynamic
  highp vec2 sidel = vec2(sunpos.x*.35+.65,sunpos.y*0.3529+.7);
  highp float ys = smoothstep(-0.1,0.1,sunpos.y);
  highp float x = ((db.x>0.)?(1.2-sidel.x):sidel.x);
  
  return
  ((db.y>-0.1 && db.y <0.1)?1.:((db.y>0.)?sidel.y:min(mix(sidel.y*.55,pow(1.3-sidel.y,.9),ys),.5)))*
  ((db.z>-0.1 && db.z <0.1)?1.:((db.z>0.)?sidel.y-.05:max((sidel.y-.1)*0.6,0.25)))*
  ((db.x>-0.1 && db.x <0.1)?1.:(mix(x*.6,1.2-x,pow(sunpos.y*.5+.5,1.5))));
  #else
  return ((db.y>-0.1 && db.y <0.1)?1.:((db.y>0.)? 1.: 0.5))*
  ((db.z>-0.1 && db.z <0.1)?1.:.6)*
  ((db.x>-0.1 && db.x <0.1)?1.:.8);
  #endif
}

#endif

#if SPECULAR
highp vec4 specularf(float lposx, vec4 diffuse) {

  highp vec3 N = normalize(wpos);
  highp vec3 L = normalize(wpos - vec3(lposx * 1500.,600.,0.));
  highp vec3 R = reflect(L, N);
  
  return  
  pow(mxzo(dot(R, -N)), 15.) * vec4( vec3(1.5-dd)*.5, diffuse.a*.2) * diffuse * 0.6;
}
#endif

void main()
{
#ifdef BYPASS_PIXEL_SHADER
	gl_FragColor = vec4(0, 0, 0, 0);
	return;
#else

#if USE_TEXEL_AA
	vec4 diffuse = texture2D_AA(TEXTURE_0, uv0);
#else
	vec4 diffuse = texture2D(TEXTURE_0, uv0);
#endif

#ifdef SEASONS_FAR
	diffuse.a = 1.0;
#endif

#if USE_ALPHA_TEST
	#ifdef ALPHA_TO_COVERAGE
	#define ALPHA_THRESHOLD 0.05
	#else
	#define ALPHA_THRESHOLD 0.5
	#endif
	if(diffuse.a < ALPHA_THRESHOLD)
		discard;
#endif

vec4 inColor = color;

#if defined(BLEND)
	diffuse.a *= inColor.a;
#endif
  
  highp vec2 fuv = uv1;
  fuv.x = pow(fuv.x,6.);
  
  #ifdef dynamic
  highp vec2 duv = uv1;
  #else
  highp vec2 duv = uv1;
  duv.x = pow(duv.x,4.);
  #endif

  float nbt = saturate(NIGHTBRIGHTNESS);
  highp float bwc = max(pow(dd,1.4),nbt);

#if !defined(ALWAYS_LIT)
	diffuse *= texture2D( TEXTURE_1, duv );
#endif


#ifndef SEASONS
	#if !USE_ALPHA_TEST && !defined(BLEND)
		diffuse.a = inColor.a;
	#endif
  #if VANILLASHADOW
	diffuse.rgb *= inColor.rgb;
	#else
	float l=1.;
	if(C.a==1.){
  if(C.r>C.g)l = .5;
	if(C.g>C.b)l = .0;
	}
  else if(l==1.)l=.3;
	if(l!=1.)diffuse.rgb *= mix(nc,C.rgb,l);
	#endif
#else
	vec2 uv = inColor.xy;
	diffuse.rgb *= mix(vec3(1.0), texture2D( TEXTURE_2, uv).rgb * 2.0, inColor.b);
	diffuse.rgb *= inColor.aaa;
	diffuse.a = 1.0;
#endif

  highp float wave = waveb();
  float wsflag;
  float uwflag;
  
#ifdef FOG
  if(FOG_CONTROL.x <0.1 && FC.b > FC.r && !nether)uwflag=1.;
#endif
  
#if defined(FANCY) && !defined(ALPHA_TEST)
if(waters)wsflag= 1.;
if(ender && C.b>C.g)wsflag=1.;
#endif

if(wsflag==1.){
  #if WATERSURFACE
  highp vec3 c1 = (uwflag==0.)?skc:skcu;
  highp vec3 c2 = (uwflag==0.)?skh:skhu;
	      diffuse.rgb = mix(c1 * mix(vec3(1.),c1,dd),c2,sline(0.6,0.9));
	      diffuse.a *= skp + 0.6;
	      diffuse.rgb *= wave;
  #elif (VANILLASHADOW==0)
      diffuse.rgb *= inColor.rgb;
  #endif
}

if(uwflag==1. && wsflag==0.){
    diffuse.rgb *= 0.6;
      diffuse.rgb *= FC.rgb+jh*.3+0.5;
      #if UNDERWATERCAUSTICS
        diffuse.rgb *= mix(1.0, dp(wave), uv1.y);
      #endif
}

#if FOGCOLVIEW
  diffuse.rgb = FC.rgb;
#endif

#if SIDEDIRLIGHT
  if(wsflag==0.){
  float sdl = bwc*mix(sidel(),sidel()*.5+.5,fuv.x);
  diffuse.rgb *= mix(1.,sdl,(plants)?mix(1.-nbt*.3,.5,pow(dd,1.5-nbt*.3)):1.);
  diffuse.rgb *= (((db.y>-0.1 && db.y <0.1)?skh:skc)*.35+.8)*(1.+ssd*.6);
  }
#endif

  float shadow;
#if SHADOW 
  if(wsflag==0. && db.y>-0.1){
  shadow = smoothstep(0.89, 0.76, uv1.y);
  shadow = mix(0.0, 0.35, shadow);
  diffuse.rgb *= mix(1., 0., shadow);
  }
#endif

#if SPECULAR
  diffuse += 
  specularf( 1., diffuse) + 
  specularf(-1., diffuse);
#endif

#if LIGHT
vec3 base = (uwflag==0.)?vec3(16.,7.,3.5):vec3(5.5,9.,12.);
vec3 lightc = mix(base,vec3(1.),((onether)?0.7:(1.-rain*.15))*pow(min(dd,.9),pow(1.-nbt,1.3)));
diffuse.rgb *= mix(vec3(1.),lightc,fuv.x);
#endif

if(uwflag+wsflag==0.)diffuse.rgb *= 1.-rain*dd*.35;
if(onether&&FOG_CONTROL.x<0.1)diffuse.rgb *= 2.5;
#ifndef dynamic
else diffuse.rgb *= mix(1.,0.7,ssd);
#endif


#if DEPTHVIEW
  diffuse.rgb = vec3(spos.z/100.);
#endif

#ifdef FOG
	diffuse.rgb = mix( diffuse.rgb, fogColor.rgb, fogColor.a );
#endif

#if TONEMAPPING
  diffuse.rgb = tonemap(diffuse.rgb);
#endif
	gl_FragColor = diffuse;

#endif // BYPASS_PIXEL_SHADER
}
